﻿#if       !defined(INCLUDED_SZ_FILE_ARCHIVE_VOLUME)
#define            INCLUDED_SZ_FILE_ARCHIVE_VOLUME

#if       !defined(INCLUDED_SZ_COMMON)
#include  <szCommon.hpp>
#endif // !defined(INCLUDED_SZ_COMMON)

#if       !defined(INCLUDED_SZ_ARCHIVE_VOLUME)
#include  <szArchiveVolume.hpp>
#endif // !defined(INCLUDED_SZ_ARCHIVE_VOLUME)

SZ_NS_BEG(szpp)

/// <summary>
/// 実在するファイルにデータが格納されているアーカイブボリュームを表すクラス。
/// </summary>
class SZ_SPEC FileArchiveVolume : public ArchiveVolume
{
public:

  /// <summary>
  /// ファイルパスを指定するコンストラクタ。
  /// </summary>
  /// <param name="path">アーカイブボリュームのデータを格納するファイルのフルパス。</param>
  FileArchiveVolume(const szstring &path);
  /// <summary>
  /// デストラクタ。
  /// </summary>
  ~FileArchiveVolume();

protected:

  virtual const szstring & DoGetVirtualPath() const;
  virtual void DoSetVirtualPath(const szstring & path);
  virtual HRESULT DoGetArchiveStream(IInStream ** ppStream);

private:

  szstring path;

};

SZ_NS_END(szpp)

#endif // !defined(INCLUDED_SZ_FILE_ARCHIVE_VOLUME)
